<?php

namespace App\Http\Middleware;

use App\Libraries\Utils;
use Closure;
use \Auth;

class PublisherAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check()) {
            if (Utils::isPublisher(Auth::user()->id)) {
                return $next($request);
            } else {

                if (Utils::isCustomer(Auth::user()->id)) {
                    return redirect()->to('/customer');
                }

                if (Utils::isAdmin(Auth::user()->id)) {
                    return redirect()->to('/publisher');
                }

            }
        } else {
            return redirect()->to('/login');
        }
    }
}
